#!/bin/bash

gt_path=/extendplus/zhaijq/CASP15_set/new_gt
pred_path=/extendplus/zhaijq/CASP15_set/new_pred    #Current directory of the file, please modify this before running.

for file in  $(ls $gt_path)
do
	gt=$gt_path/$file
        pred=$pred_path/$file
        fnat=$(python fnat.py $gt $pred)
	SDDM=$(python casp.py $gt $pred)
	CDDM=$(python maskzo.py $gt $pred)
	SDDMscaled=$(echo "1/($SDDM/8.5+1)"|bc)
	CDDMscaled=$(echo "1/($CDDM/2.5+1)"|bc)
	BDM=$(echo "(0.25*$fnat+0.75*(0.55*$SDDMscaled-0.45*$CDDMscaled))*$SDDMscaled^4"|bc)
        echo $file","$BDM >> BDMresult.csv    #Place the obtained results into a file, which can be customized as needed.
        break
        
done
